var s = require('struct-fu');

const CardoConfigUser_st = s.struct('parameters', [
    s.ubit('grouping_channel', 4),
    s.ubit('language', 4),

    s.ubit('VAD_threshold', 2),
    s.ubit('mic_threshold', 2),
    s.ubit('asr_enable', 1),
    s.ubit('voice_prompt_enable', 1),
    s.ubit('FM_radio_band', 1),
    s.ubit('RDS_enable', 1),

    s.ubit('parallel_audio_enable', 1),
    s.ubit('two_way_mix_enable', 1),
    s.ubit('ld_enable', 1),
    s.ubit('self_hear_enable', 1),
    s.ubit('two_way_sharing', 1),
    s.ubit('reserved0', 3),

    s.ubit('reserved1', 8),
]);

const user_mic_gain_pskey_st = s.struct([
  s.uint16('mic_gain_low'),
  s.uint16('mic_gain_med'),
  s.uint16('mic_gain_high')
])

exports.user_mic_gain_pskey_st = user_mic_gain_pskey_st

function UserNewVAD2Settings(name) {
  return s.struct(name, [
    s.ubit('threshold', 8),
    s.ubit('min_length', 8),
    s.ubit('h_thresh', 8),
    s.ubit('abs_thresh', 8)])
}

exports.user_vad_pskey_st = s.struct([
  UserNewVAD2Settings('vad_config_low'),
  UserNewVAD2Settings('vad_config_medium'),
  UserNewVAD2Settings('vad_config_high'),
])

      //  /* Word 0 */
      //  unsigned reserved_0 :3; /* MSB */
      //  unsigned vox_priority :2; /* 0 -> Channel A, 1 -> Channel B, 2 -> Channel C, 3 -> not used */
      //  unsigned agc_selected_set :3; /* 0 -> Medium, 1 -> Low, 2 -> High, 3 -> Schuberth, 4-> no agc, 7 -> max AGC test */
      //  unsigned offset_base_lang :8; /* LSB */
      //  /* Word 1 */
      //  unsigned reserved_1 :8; /* MSB */
      //  /*------*/
      //  unsigned hfp_priority :1; /* 0: vol+ (PSKey12), 1: vol- (PSKey13) */
      //  unsigned a2dp_ic_priority :1; /* 0: IC, 1: ADP */
      //  unsigned avc_disable :1; /* Automatic Volume Control (needs Echo Canceler chip - BK only) */
      //  unsigned vcm_disable :1;
      //  unsigned ctl_enable :1;
      //  unsigned vox_level :2; /* 0 -> Medium, 1 -> Low, 2 -> High */
      //  unsigned reserved_2:1; /* LSB */
      //  /* Word 2 */
      //  unsigned reserved_3 :6; /* MSB */
      //  unsigned SwitchOutputSpeakersDirection:1; /* 0 for default output speakers direction, 1 for switched output speakers direction */
      //  unsigned asr_nowspeak_alwaysOn :1; /* 0: without asr always on, 1: asr with always on */
      //  unsigned force_asr_nowspeak :1; /* 0: use cardo asr when not in Chinese, 1: force use nowspeak asr regardless the language  */
      //  unsigned music_sharing_enable :1; /* 0: disable, 1 enable */
      //  unsigned fm_sharing_enable :1; /* 0: disable, 1 enable */
      //  unsigned audio_mix_enable :1;  /* 0: disable, 1 enable */
      //  unsigned pt_dmc_mode_active:1; /* 0: Legacy mode, 1 Packtalk mode */
      //  unsigned ic_to_phone_enable :1; /* 0: disable 1: enable  - connect via mobile if BT communication fails*/
      //  unsigned vox_open_ic :1; /* 0: Vox start VC (default G9/Shoei), 1: VOX open IC */
      //  unsigned vox_disable :1; /* LSB */

      //   /* Word 3 */
      //  unsigned ns_asr_ConfidenceThForOkGoogleAndHiSiri:                   8;  /*LSB*/
      //          unsigned ns_asr_EndDetectTh:                                        8;  /*MSB*/

// This struct is referred to in the cardo code as 'UserConfigData_ut'. To avoid confusion,with the CardoConfigUser_st struct, it is named here ConfigParams_st
const ConfigParams_st = s.struct([
  s.ubit('reserved_0', 3),
  s.ubit('vox_priority', 2),
  s.ubit('agc_selected_set', 3),

  s.ubit('offset_base_lang', 8),

  s.ubit('reserved_1', 8),

  s.ubit('hfp_priority', 1),
  s.ubit('a2dp_ic_priority', 1),
  s.ubit('avc_disable', 1),
  s.ubit('vcm_disable', 1),
  s.ubit('ctl_enable', 1),
  s.ubit('vox_level', 2),
  s.ubit('reserved_2', 1),

  s.ubit('reserved_3', 6),
  s.ubit('SwitchOutputSpeakersDirection', 1),
  s.ubit('asr_nowspeak_alwaysOn', 1),

  s.ubit('force_asr_nowspeak', 1),
  s.ubit('music_sharing_enable', 1),
  s.ubit('fm_sharing_enable', 1),
  s.ubit('audio_mix_enable', 1),
  s.ubit('pt_dmc_mode_active', 1),
  s.ubit('ic_to_phone_enable', 1),
  s.ubit('vox_open_ic', 1),
  s.ubit('vox_disable', 1),

  s.uint16('reserved_4'),
])

exports.config_params_st = ConfigParams_st

exports.user_mic_gain_pskey_st = user_mic_gain_pskey_st

const PHONE_NUMBER_LEN = 18
const BT_FRIENDLY_NAME_LEN = 16
exports.crd_cfg_pskey_usr_st = s.struct(
  [CardoConfigUser_st,
   s.byte('emergency_dial', PHONE_NUMBER_LEN),
   s.byte('speed_dial', PHONE_NUMBER_LEN),
   s.byte('friendly_name', BT_FRIENDLY_NAME_LEN)])

const CardoConfigHW_st = s.struct('parameters', [
  s.ubit('asr_magic_word_index', 4),
  s.ubit('battery_type', 2),
  s.ubit('stereo_out_reverse', 1),
  s.ubit('fm_enable', 1),
  s.ubit('bt_enable', 1),
  s.ubit('power_led_is_external', 1),
  s.ubit('rf_certification_region', 4),
  s.ubit('reserved', 2)
])

const bq27425_batterySpec_st = s.struct('m_batterySpec', [
  s.uint16('m_DesignCapacity'),
  s.uint16('m_DesignEnergy'),
  s.uint16('m_TerminateVoltage'),
  s.uint16('m_TaperCurrent'),
  s.uint16('m_TaperVoltage'),
  s.uint16('m_SleepCurrent'),
  s.uint16('m_ChargeTerminationVoltage'),
  s.int16('m_PackOffsetVoltage')
])

exports.crd_cfg_pskey_hw_st = s.struct([
  CardoConfigHW_st,
  s.uint16('m_nvmProgramStatus'),
  bq27425_batterySpec_st
])

const FM_NUMBER_OF_STATIONS = 6;
exports.fm_stations_pskey_st = s.struct([
  s.uint16('index'),
  s.uint16('station_frequency', FM_NUMBER_OF_STATIONS),
  s.uint16('last_played_frequency'),
])


// Values taken from BTM/VM/Cardo/Audio/cardo_volume.c
exports.volumes_st = s.struct([
  s.uint16('standby'),
  s.uint16('ic'),
  s.uint8('mobile_phone_1'),
  s.uint8('mobile_phone_2'),
  s.uint16('fm'),
  s.uint8('sh'),
  s.uint8('ld'),
  s.uint8('a2dp_1'),
  s.uint8('a2dp_2'),
  s.uint16('parallel_mix')
])

var grouping_v2_st = s.struct('grouping_manager_handler', [
    s.uint16('format_version'),
    s.uint16('group_max_members'),
    s.uint16('member_id'),
    s.uint16('group_unit_stored'),
    s.uint16('group_mask'),
    s.uint16('reserved')
  ])

exports.User_pskey_28_st = s.struct([
  s.uint16('BitPool'),
  s.ubit('reserved0', 14),
  s.ubit('factory_reset', 1),
  s.ubit('reserved1', 0)
])

exports.keepalive_pskey = s.struct([s.uint16('keepalive')])

const GROUP_BUFFER_SIZE = 426 * 2
const PADDING_SIZE = GROUP_BUFFER_SIZE - grouping_v2_st.size
var grouping_v2_buffer = s.struct([
  grouping_v2_st,
  s.uint8('reserved', PADDING_SIZE)
])

function pack_group_buffer(id, mask) {
  group_info = {
    'format_version' : 2,
    'group_max_members': 0xff,
    'member_id': id,
    'group_unit_stored': 0xff,
    'group_mask': mask,
    'reserved': 0xff
  }

  let complete_group_buffer = {
    'grouping_manager_handler' : group_info,
    'reserved': Array(PADDING_SIZE).fill(0xff),
  }

  return grouping_v2_buffer.pack(complete_group_buffer)
}

exports.pack_group_buffer = pack_group_buffer
